#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_MSBOS : BaseTest 
	{

		private BOL.Msbos msbos;
		private BOL.Msbos _tstMsbos;
		private DataTable _dtMsbos;
		private DataRow _drMsbos;
		

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtMsbos = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM MSBOS WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", false);
				if (this._dtMsbos.Rows.Count == 0)
				{
					UnitTestUtil.RunSQL("UPDATE MSBOS SET RecordStatusCode = 'A' WHERE DivisionCode = '" + this.TestDivisionCode + "' AND MsbosGuid IN (SELECT TOP 1 MsbosGuid FROM MSBOS WHERE RecordStatusCode <> 'A' AND DivisionCode = '" + this.TestDivisionCode + "')");
					this._dtMsbos = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM MSBOS WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", false);
				}

				this._drMsbos = this._dtMsbos.Rows[0];

				this.RefreshData = false;

			}

			_tstMsbos = new BOL.Msbos(_drMsbos);
			msbos = new BOL.Msbos();
		}

		[Test]
		public void Ctor_Pass()
		{			
			msbos = new BOL.Msbos();
			Assert.IsTrue(msbos!=null);
		}
        
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}


		[Test]
		public void Ctor_DataRow_Pass()
		{	
			BOL.Msbos msbos1 = new BOL.Msbos();
			msbos1.SurgeryName = _drMsbos["SurgeryName"].ToString();
			//
			BOL.Msbos msbos2 = new BOL.Msbos(this._drMsbos);
			//
			Assert.AreEqual(msbos1.SurgeryName,msbos2.SurgeryName);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{	
			DataRow dr1 = this._dtMsbos.NewRow();

			DataRow dr2 = this._tstMsbos.LoadDataRowFromThis(dr1);

			Assert.AreEqual(dr1, dr2);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThisFail()
		{
		}

		[Test]
		public void SurgeryName_Get()
		{			
			string _surgeryName = msbos.SurgeryName;
			Assert.AreEqual(msbos.SurgeryName,_surgeryName);
			//	
			_surgeryName = _tstMsbos.SurgeryName;
			Assert.AreEqual(_tstMsbos.SurgeryName,_surgeryName);
		}

		[Test]
		public void SurgeryName_Set_Pass()
		{			
			string _surgeryName = string.Empty;
			msbos.SurgeryName = _surgeryName;
			Assert.AreEqual(_surgeryName,msbos.SurgeryName);
			//
			_surgeryName = string.Empty.PadRight(50,'X');
			msbos.SurgeryName = _surgeryName;
			Assert.AreEqual(_surgeryName,msbos.SurgeryName);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BOL.BusinessObjectException))]
		public void SurgeryName_Set_Fail()
		{			
			string _surgeryName = string.Empty.PadRight(51,'X');
			msbos.SurgeryName = _surgeryName;
		}

		[Test]
		public void MsbosGuid_Get()
		{			
			Guid _msbosGuid = msbos.MsbosGuid;
			Assert.AreEqual(msbos.MsbosGuid,_msbosGuid);
			//	
			_msbosGuid = _tstMsbos.MsbosGuid;
			Assert.AreEqual(_tstMsbos.MsbosGuid,_msbosGuid);
		}

		[Test]
		public void MsbosGuid_Set()
		{			
			Guid _msbosGuid = Guid.Empty;
			msbos.MsbosGuid = _msbosGuid;
			Assert.AreEqual(_msbosGuid,msbos.MsbosGuid);
			//
			_msbosGuid = Guid.NewGuid();
			msbos.MsbosGuid = _msbosGuid;
			Assert.AreEqual(_msbosGuid,msbos.MsbosGuid);
		}

		[Test]
		public void BloodComponentClasses_Get()
		{			
			DataRow[] dr = msbos.BloodComponentClasses;
			Assert.AreEqual(msbos.BloodComponentClasses,dr);
		}

		[Test]
		public void BloodComponentClasses_Set()
		{	
			msbos = new BOL.Msbos();

			DataTable dataTable = msbos.GetOrderableComponentClasses();
			DataRow[] dr = new DataRow[]{ dataTable.NewRow(), dataTable.NewRow()};
			msbos.BloodComponentClasses = dr;
			Assert.AreEqual(dr,msbos.BloodComponentClasses);
		}


		[Test]
		public void IsTypeAndScreen_Get()
		{			
			bool _isTypeAndScreen = msbos.IsTypeAndScreen;
			Assert.AreEqual(msbos.IsTypeAndScreen,_isTypeAndScreen);
			//	
			_isTypeAndScreen = _tstMsbos.IsTypeAndScreen;
			Assert.AreEqual(_tstMsbos.IsTypeAndScreen,_isTypeAndScreen);
		}

		[Test]
		public void IsTypeAndScreen_Set()
		{			
			bool _isTypeAndScreen = false;
			msbos.IsTypeAndScreen = _isTypeAndScreen;
			Assert.AreEqual(_isTypeAndScreen,msbos.IsTypeAndScreen);
			//
			_isTypeAndScreen = true;
			msbos.IsTypeAndScreen = _isTypeAndScreen;
			Assert.AreEqual(_isTypeAndScreen,msbos.IsTypeAndScreen);
		}

		[Test]
		public void RecordStatusCode_Get()
		{			
			Common.RecordStatusCode _recordStatusCode = msbos.RecordStatusCode;
			Assert.AreEqual(msbos.RecordStatusCode,_recordStatusCode);
			//	
			_recordStatusCode = _tstMsbos.RecordStatusCode;
			Assert.AreEqual(_tstMsbos.RecordStatusCode,_recordStatusCode);
		}

		[Test]
		public void RecordStatusCode_Set()
		{			
			Common.RecordStatusCode _recordStatusCode = Common.RecordStatusCode.Inactive;
			msbos.RecordStatusCode = _recordStatusCode;
			Assert.AreEqual(_recordStatusCode,msbos.RecordStatusCode);
			
			msbos.IsDirty = false;

			_recordStatusCode = Common.RecordStatusCode.Active;
			msbos.RecordStatusCode = _recordStatusCode;
			Assert.AreEqual(_recordStatusCode,msbos.RecordStatusCode);

			Assert.AreEqual( true, msbos.IsDirty );
		}


		[Test]
		public void Clear_Pass()
		{	
			BOL.Msbos msbos3 = (BOL.Msbos)_tstMsbos.Clone();
			msbos3.Clear();
			Assert.AreEqual(string.Empty,msbos3.SurgeryName);
			Assert.AreEqual(Guid.Empty,msbos3.MsbosGuid);
			Assert.AreEqual(false,msbos3.IsTypeAndScreen);
			Assert.AreEqual(Common.RecordStatusCode.Unknown,msbos3.RecordStatusCode);
			Assert.AreEqual(false,msbos3.IsDirty);
			Assert.AreEqual(true,msbos3.IsNew);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Clear_Fail()
		{	
		}


		[Test]
		public void Save_Pass()
		{			
			DataSet ds = DAL.Msbos.GetMsbosEntries();
			ds.AcceptChanges();
			//
			Guid msbosGuid = Guid.NewGuid();
			Guid msbosComponentGuid = Guid.NewGuid();
			//
			if ((ds.Tables.Count>0)&&(ds.Tables[0].Rows.Count>0))
			{
				//Update a MSBOS entry
				ds.Tables[0].Rows[0][TABLES.Msbos.LastUpdateUser] = Environment.UserName;
				//Now insert a new MSBOS entry
				DataRow drNewMsbos = ds.Tables[0].NewRow();
				drNewMsbos[TABLES.Msbos.MsbosGuid] = msbosGuid;
				drNewMsbos[TABLES.Msbos.TypeAndScreenIndicator] = false;
				drNewMsbos[TABLES.Msbos.NoBloodRequiredIndicator] = false;
				drNewMsbos[TABLES.Msbos.DivisionCode] = this.TestDivisionCode;
				drNewMsbos[TABLES.Msbos.RecordStatusCode] = 'A';
				drNewMsbos[TABLES.Msbos.SurgeryName] = System.DateTime.Now.ToString();
				drNewMsbos[TABLES.Msbos.LastUpdateUser] = Common.LogonUser.LogonUserName;
				ds.Tables[0].Rows.Add(drNewMsbos);
			}
			//
			if ((ds.Tables.Count>1)&&(ds.Tables[1].Rows.Count>0))
			{
				//Update a MSBOS component entry
				ds.Tables[1].Rows[0][TABLES.MsbosComponentClass.LastUpdateUser] = Environment.UserName;
				//Now insert a new MSBOS component entry
				DataRow drNewMsbosComponent = ds.Tables[1].NewRow();
				drNewMsbosComponent.ItemArray = ds.Tables[1].Rows[0].ItemArray;
				drNewMsbosComponent[TABLES.MsbosComponentClass.MsbosGuid] = msbosGuid;
				drNewMsbosComponent[TABLES.MsbosComponentClass.MsbosComponentClassGuid] = msbosComponentGuid;
				drNewMsbosComponent[TABLES.MsbosComponentClass.RowVersion] = DBNull.Value;
				ds.Tables[1].Rows.Add(drNewMsbosComponent);
			}

			bool pass = msbos.Save(ds, Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, pass, "Save");
			//
			if (pass)
			{
				//Clean up: Delete inserted MSBOS and MSBOS component class
				UnitTestUtil.RunSQL("DELETE FROM dbo.MsbosComponentClass WHERE MsbosComponentClassGuid = '"+msbosComponentGuid.ToString()+"'");
				UnitTestUtil.RunSQL("DELETE FROM dbo.Msbos WHERE MsbosGuid = '"+msbosGuid.ToString()+"'");
			}
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(NullReferenceException))]
		public void Save_Fail()
		{
			DataSet ds = new DataSet();
			bool pass = msbos.Save(null, Common.UpdateFunction.UnitTests);
			Assert.IsTrue(pass == false);
		}

		[Test]
		public void GetOrderableComponentClasses_Pass()
		{	
			BOL.Msbos msbos4 = new BOL.Msbos();

			DataTable _dtMsbos = msbos4.GetOrderableComponentClasses();
			Assert.IsTrue(_dtMsbos.Rows.Count>0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderableComponentClasses_Fail()
		{	
		}


		[Test]
		public void GetMsbosEntries_Pass()
		{	
			BOL.Msbos msbos5 = new BOL.Msbos();

			DataSet ds = msbos5.GetMsbosEntries();
			Assert.IsTrue(ds.Tables.Count==2);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMsbosEntries_Fail()
		{	
		}

		[Test]
		public void IsNoBloodRequired_Pass()
		{	
			this._tstMsbos.IsNoBloodRequired=true;

			Assert.IsTrue(this._tstMsbos.IsNoBloodRequired);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsNoBloodRequired_Fail()
		{	
		}

	}
}
#endif

